# -*- coding: utf-8 -*-
"""
Created on Wed Oct 13 20:08:37 2021

@author: chunr
"""

import matplotlib.pyplot as plt
import matplotlib as mpl
import numpy as np



def autolabel(rects):
 for rect in rects:
  height = rect.get_height()
  plt.text(rect.get_x()+rect.get_width()/2.-0.15, 1.03*height, '%s' % float(height),fontsize=18)
  
mpl.rcParams["font.sans-serif"] = ["SimHei"]
mpl.rcParams["axes.unicode_minus"] = False

x = np.arange(3)
#y = [21.9341, 28.5361, 29.1969]
#y1 = [0.6493, 0.8301, 0.8660]

y = [21.93, 28.54, 29.20]
y1 = [0.65, 0.83, 0.87]

bar_width = 0.35
tick_label = ["t=0", "t=10", "t=100"]

from matplotlib.pyplot import figure
import matplotlib.pyplot as plt
figure(figsize=(4.5,4))
plt.grid(linestyle='-')
h1 = plt.bar(x, y, bar_width, align="center", color="deepskyblue", label=r"$|\nabla_{\theta_\mu}f|$", alpha=1)
h2 = plt.bar(x+bar_width, y1, bar_width, color="orange", align="center", label=r"$|\nabla_{\theta_\sigma}f|$", alpha=1)
plt.title(r"$|\nabla_{\theta_\mu}f|$ vs $|\nabla_{\theta_\sigma}f|$",fontsize=18)
plt.ylim([0,35])
plt.xticks(x+bar_width/2, tick_label,fontsize=18)
plt.yticks(fontsize=18)
autolabel(h1)
autolabel(h2)

legend = plt.legend()
legend.get_frame().set_edgecolor('black')

plt.show()